@include('admin.layouts.components.asset_datatables')

<div class="box box-info">
    <div class="box-body">
        <div class="row">
            <div class="col-sm-2">
                <select id="tahun" class="form-control input-sm select2">
                    <option value="">Pilih Tahun</option>
                    @foreach ($tahun as $item)
                        <option>{{ $item->tahun_anggaran }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-sm-10">
                <a
                    href="{{ ci_route('bumindes_hasil_pembangunan/dialog/cetak') }}"
                    class="btn btn-social bg-purple btn-sm visible-xs-block visible-sm-inline-block visible-md-inline-block visible-lg-inline-block"
                    title="Cetak Buku Hasil Pembangunan"
                    data-remote="false"
                    data-toggle="modal"
                    data-target="#modalBox"
                    data-title="Cetak Buku Hasil Pembangunan"
                ><i class="fa fa-print "></i> Cetak</a>
                <a
                    href="{{ ci_route('bumindes_hasil_pembangunan/dialog/unduh') }}"
                    class="btn btn-social bg-navy btn-sm visible-xs-block visible-sm-inline-block visible-md-inline-block visible-lg-inline-block"
                    title="Unduh Buku Hasil Pembangunan"
                    data-remote="false"
                    data-toggle="modal"
                    data-target="#modalBox"
                    data-title="Unduh Buku Hasil Pembangunan"
                ><i class="fa fa-download"></i> Unduh</a>
            </div>
        </div>
        <hr>
        {!! form_open(null, 'id="mainform" name="mainform"') !!}
        <div class="table-responsive">
            <table class="table table-bordered table-hover tabel-daftar" id="tabeldata">
                <thead class="bg-gray color-palette">
                    <tr>
                        <th>NOMOR URUT</th>
                        <th>JENIS/NAMA HASIL PEMBANGUNAN</th>
                        <th>VOLUME</th>
                        <th>BIAYA</th>
                        <th>LOKASI</th>
                        <th>KETERANGAN</th>
                    </tr>
                </thead>
            </table>
        </div>
        </form>
    </div>
</div>

@push('scripts')
    <script>
        $(document).ready(function() {
            var TableData = $('#tabeldata').DataTable({
                responsive: true,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ ci_route('bumindes_hasil_pembangunan.datatables') }}",
                    data: function(req) {
                        req.tahun = $('#tahun').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        class: 'padat',
                        searchable: false,
                        orderable: false
                    },
                    {
                        data: 'judul',
                        name: 'judul',
                        searchable: true,
                        orderable: true
                    },
                    {
                        data: 'volume',
                        name: 'volume',
                        searchable: true,
                        orderable: true
                    },
                    {
                        data: 'anggaran',
                        name: 'anggaran',
                        render: $.fn.dataTable.render.number('.', ',', 0, 'Rp '),
                        searchable: true,
                        orderable: true
                    },
                    {
                        data: 'alamat',
                        name: 'wilayah.dusun',
                        searchable: true,
                        orderable: true
                    },
                    {
                        data: 'keterangan',
                        name: 'keterangan',
                        searchable: true,
                        orderable: true
                    },
                ],
                order: [
                    [1, 'desc']
                ]
            });

            $('#tahun').change(function() {
                TableData.draw()
            })
        });
    </script>
@endpush
